/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.dao.Entity;
import org.jetbrains.exposed.dao.EntityCache;
import org.jetbrains.exposed.dao.EntityCacheKt;
import org.jetbrains.exposed.dao.EntityHookKt;
import org.jetbrains.exposed.dao.EntityLifecycleInterceptorKt;
import org.jetbrains.exposed.dao.id.IdTable;
import org.jetbrains.exposed.sql.Key;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.TableKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.BatchUpdateStatement;
import org.jetbrains.exposed.sql.statements.DeleteStatement;
import org.jetbrains.exposed.sql.statements.GlobalStatementInterceptor;
import org.jetbrains.exposed.sql.statements.InsertStatement;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.StatementContext;
import org.jetbrains.exposed.sql.statements.StatementGroup;
import org.jetbrains.exposed.sql.statements.UpdateStatement;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ-\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\rJ;\u0010\u0016\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00122\u0018\u0010\u0015\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0012H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001b\u0010\u001a\u001a\u00020\t*\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/exposed/dao/EntityLifecycleInterceptor;", "Lorg/jetbrains/exposed/sql/statements/GlobalStatementInterceptor;", "Lorg/jetbrains/exposed/sql/Transaction;", "transaction", "", "Lorg/jetbrains/exposed/sql/statements/StatementContext;", "contexts", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "executedStatement", "", "afterExecution", "(Lorg/jetbrains/exposed/sql/Transaction;Ljava/util/List;Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;)V", "beforeCommit", "(Lorg/jetbrains/exposed/sql/Transaction;)V", "context", "beforeExecution", "(Lorg/jetbrains/exposed/sql/Transaction;Lorg/jetbrains/exposed/sql/statements/StatementContext;)V", "beforeRollback", "", "Lorg/jetbrains/exposed/sql/Key;", "", "userData", "keepUserDataInTransactionStoreOnCommit", "(Ljava/util/Map;)Ljava/util/Map;", "Lorg/jetbrains/exposed/sql/Query;", "query", "flushEntities", "(Lorg/jetbrains/exposed/sql/Transaction;Lorg/jetbrains/exposed/sql/Query;)V", "<init>", "()V", "exposed-dao"})
public final class EntityLifecycleInterceptor
implements GlobalStatementInterceptor {
    @Override
    @NotNull
    public Map<Key<?>, Object> keepUserDataInTransactionStoreOnCommit(@NotNull Map<Key<?>, ? extends Object> userData) {
        Intrinsics.checkNotNullParameter(userData, (String)"userData");
        Map<Key<?>, Object> $this$filterValues$iv = userData;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry<Key<?>, Object> entry$iv : $this$filterValues$iv.entrySet()) {
            Object it = entry$iv.getValue();
            boolean bl = false;
            if (!(it instanceof EntityCache)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void beforeExecution(@NotNull Transaction transaction2, @NotNull StatementContext context) {
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Statement<?> statement = context.getStatement();
        if (statement instanceof Query) {
            this.flushEntities(transaction2, (Query)statement);
        } else if (statement instanceof DeleteStatement) {
            EntityCacheKt.flushCache(transaction2);
            EntityCacheKt.getEntityCache(transaction2).removeTablesReferrers$exposed_dao(CollectionsKt.listOf((Object)((DeleteStatement)statement).getTable()), false);
            if (!EntityLifecycleInterceptorKt.access$isExecutedWithinEntityLifecycle()) {
                void $this$forEach$iv;
                Iterator $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = statement.getTargets();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv = iterator2.next();
                    if (!(element$iv$iv instanceof IdTable)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IdTable it = (IdTable)element$iv;
                    boolean bl = false;
                    Map<Object, Entity<?>> map2 = EntityCacheKt.getEntityCache(transaction2).getData().get(it);
                    if (map2 == null) continue;
                    map2.clear();
                }
            }
        } else if (statement instanceof InsertStatement) {
            EntityCacheKt.flushCache(transaction2);
            EntityCacheKt.getEntityCache(transaction2).removeTablesReferrers$exposed_dao(CollectionsKt.listOf((Object)((InsertStatement)statement).getTable()), true);
        } else if (!(statement instanceof BatchUpdateStatement)) {
            if (statement instanceof UpdateStatement) {
                EntityCacheKt.flushCache(transaction2);
                EntityCacheKt.getEntityCache(transaction2).removeTablesReferrers$exposed_dao((Collection<? extends Table>)TableKt.targetTables(((UpdateStatement)statement).getTargetsSet()), false);
                if (!EntityLifecycleInterceptorKt.access$isExecutedWithinEntityLifecycle()) {
                    void $this$forEach$iv;
                    Iterable $this$filterIsInstance$iv = statement.getTargets();
                    boolean $i$f$filterIsInstance = false;
                    Iterable $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof IdTable)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IdTable it = (IdTable)element$iv;
                        boolean bl = false;
                        Map<Object, Entity<?>> map3 = EntityCacheKt.getEntityCache(transaction2).getData().get(it);
                        if (map3 == null) continue;
                        map3.clear();
                    }
                }
            } else if (statement.getType().getGroup() == StatementGroup.DDL) {
                EntityCacheKt.flushCache(transaction2);
            }
        }
    }

    @Override
    public void afterExecution(@NotNull Transaction transaction2, @NotNull List<StatementContext> contexts, @NotNull PreparedStatementApi executedStatement) {
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        Intrinsics.checkNotNullParameter(contexts, (String)"contexts");
        Intrinsics.checkNotNullParameter((Object)executedStatement, (String)"executedStatement");
        EntityHookKt.alertSubscribers(transaction2);
    }

    @Override
    public void beforeCommit(@NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        List<Entity<?>> created = EntityCacheKt.flushCache(transaction2);
        EntityHookKt.alertSubscribers(transaction2);
        List<Entity<?>> createdByHooks = EntityCacheKt.flushCache(transaction2);
        EntityCache.Companion.invalidateGlobalCaches(CollectionsKt.plus((Collection)created, (Iterable)createdByHooks));
    }

    @Override
    public void beforeRollback(@NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        EntityCache entityCache2 = EntityCacheKt.getEntityCache(transaction2);
        entityCache2.clearReferrersCache();
        entityCache2.getData().clear();
        entityCache2.getInserts$exposed_dao().clear();
    }

    private final void flushEntities(Transaction $this$flushEntities, Query query2) {
        Set tables = CollectionsKt.toSet((Iterable)CollectionsKt.filterIsInstance((Iterable)query2.getTargets(), IdTable.class));
        EntityCacheKt.getEntityCache($this$flushEntities).flush(tables);
    }

    @Override
    public void afterCommit() {
        GlobalStatementInterceptor.DefaultImpls.afterCommit(this);
    }

    @Override
    public void afterRollback() {
        GlobalStatementInterceptor.DefaultImpls.afterRollback(this);
    }
}

